/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.InputStream;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerFunctionManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.Resource;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.duck.IProfilingServerFunctionManager;
import org.embeddedt.modernfix.structure.CachingStructureManager;

public class ModernFixCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"modernfix").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"upgradeStructures").requires(source -> source.m_6761_(3))).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            if (level == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Couldn't find server level"));
                return 0;
            }
            CloseableResourceManager manager = level.m_7654_().f_129740_.f_206584_();
            Map structures = manager.m_214159_("structures", p -> p.m_135815_().endsWith(".nbt"));
            int upgradedNum = 0;
            Pattern pathPattern = Pattern.compile("^structures/(.*)\\.nbt$");
            for (Map.Entry entry : structures.entrySet()) {
                ++upgradedNum;
                ResourceLocation found = (ResourceLocation)entry.getKey();
                Matcher matcher = pathPattern.matcher(found.m_135815_());
                if (!matcher.matches()) continue;
                ResourceLocation structureLocation = new ResourceLocation(found.m_135827_(), matcher.group(1));
                try {
                    InputStream resource = ((Resource)entry.getValue()).m_215507_();
                    try {
                        CachingStructureManager.readStructureTag(structureLocation, level.m_7654_().m_129933_(), resource);
                        MutableComponent msg = Component.m_237113_((String)("checked " + String.valueOf(structureLocation) + " (" + upgradedNum + "/" + structures.size() + ")"));
                        ((CommandSourceStack)context.getSource()).m_288197_(() -> ModernFixCommands.lambda$register$2((Component)msg), false);
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Throwable e) {
                    ModernFix.LOGGER.error("Couldn't upgrade structure " + String.valueOf(found), e);
                    ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("error reading " + String.valueOf(structureLocation) + " (" + upgradedNum + "/" + structures.size() + ")")));
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"All structures upgraded"), false);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"mcfunctions").requires(source -> source.m_6761_(3))).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            if (level == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Couldn't find server level"));
                return 0;
            }
            ServerFunctionManager patt0$temp = level.m_7654_().m_129890_();
            if (patt0$temp instanceof IProfilingServerFunctionManager) {
                IProfilingServerFunctionManager profiler = (IProfilingServerFunctionManager)patt0$temp;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"mcfunction runtime breakdown:"), false);
                for (String line : profiler.mfix$getProfilingResults().split("\n")) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)line), false);
                }
                return 1;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"ModernFix mcfunction profiling is not enabled on this server."));
            return 0;
        })));
    }

    private static /* synthetic */ Component lambda$register$2(Component msg) {
        return msg;
    }
}

