/*
 * Decompiled with CFR 0.152.
 */
package com.leaky.mixin;

import com.leaky.INearbyItemAwareEntity;
import com.leaky.Leaky;
import com.leaky.config.CommonConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class}, priority=999)
public abstract class ItemUpdateMixin
extends Entity
implements INearbyItemAwareEntity {
    @Shadow
    private int f_31985_;
    @Unique
    private int updateRate = 1;
    @Unique
    private int nearbyItems = 0;
    @Unique
    private boolean waterState = false;
    @Unique
    private Player closePlayer = null;
    @Unique
    private BlockPos previousPos = null;
    @Unique
    private int delay = 0;

    public ItemUpdateMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;noCollision(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Z"), require=0)
    private boolean checkCollisions(Level instance, Entity entity, AABB aabb) {
        if (this.f_19797_ < 100 || (this.f_19797_ + this.m_19879_()) % this.updateRate == 0) {
            return this.m_9236_().m_45756_((Entity)this, this.m_20191_().m_82406_(1.0E-7));
        }
        return !this.f_19794_;
    }

    @ModifyConstant(method={"tick"}, constant={@Constant(intValue=4, ordinal=0)})
    private int adaptUpdates(int constant) {
        return constant + this.updateRate;
    }

    protected boolean m_20073_() {
        if (this.f_19797_ < 20 || (this.f_19797_ + this.m_19879_()) % this.updateRate == 0) {
            this.waterState = super.m_20073_();
            return this.waterState;
        }
        return this.waterState;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void checkRate(CallbackInfo ci) {
        if (this.f_19797_ <= 1) {
            this.closePlayer = this.m_9236_().m_45930_((Entity)this, 32.0);
        }
        if ((this.f_19797_ + this.m_19879_()) % 20 == 0) {
            this.calculateUpdateRate();
        }
    }

    @Inject(method={"playerTouch"}, at={@At(value="HEAD")})
    private void onInteract(Player p_32040_, CallbackInfo ci) {
        this.updateRate = 1;
        this.delay = 300;
    }

    @Unique
    private void calculateUpdateRate() {
        this.updateRate = 1;
        if (this.f_19797_ < 300) {
            return;
        }
        if (this.delay > 0) {
            this.delay -= 20;
            return;
        }
        if (!((CommonConfiguration)Leaky.config.getCommonConfig()).improveItemPerformance) {
            return;
        }
        this.updateRate = (int)((double)this.updateRate + (double)this.f_19797_ / 200.0);
        if (this.closePlayer != null && this.closePlayer.m_20183_().m_123331_((Vec3i)this.m_20183_()) > 1024.0) {
            this.updateRate += 5;
            this.f_31985_ += 5;
        }
        if (this.nearbyItems > 0) {
            this.updateRate += this.nearbyItems / 10;
            this.f_31985_ += this.nearbyItems / 15;
        }
        if (this.previousPos != null && this.previousPos != this.m_20183_() && !this.previousPos.equals((Object)this.m_20183_())) {
            this.updateRate = 1;
            this.delay = 300;
        }
        this.previousPos = this.m_20183_();
    }

    @Override
    public int getNearbyItems() {
        return this.nearbyItems;
    }

    @Override
    public void setNearbyItems(int items) {
        this.nearbyItems = Math.max(this.nearbyItems, items);
    }
}

