/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.chatAI;

import com.google.common.collect.ImmutableList;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MoveState;
import forge.net.mca.entity.ai.chatAI.TriggerCommandInfo;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class TriggerCommandInfos {
    public static final List<TriggerCommandInfo> triggerCommands = ImmutableList.of((Object)new TriggerCommandInfo("follow-player", "Follow the player talking to you", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.FOLLOW, (Player)p), (p, v) -> v.getVillagerBrain().getMoveState() != MoveState.FOLLOW), (Object)new TriggerCommandInfo("stay-here", "Stay here for a while", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.STAY, (Player)p), (p, v) -> v.getVillagerBrain().getMoveState() != MoveState.STAY), (Object)new TriggerCommandInfo("move-freely", "Move freely when asked to leave, move, or done talking", (p, v) -> v.getVillagerBrain().setMoveState(MoveState.MOVE, (Player)p), (p, v) -> v.getVillagerBrain().getMoveState() != MoveState.MOVE), (Object)new TriggerCommandInfo("wear-armor", "Equip any armor you have", (p, v) -> v.getVillagerBrain().setArmorWear(true), (p, v) -> !v.getVillagerBrain().getArmorWear()), (Object)new TriggerCommandInfo("remove-armor", "Remove all the armor currently equipped", (p, v) -> v.getVillagerBrain().setArmorWear(false), (p, v) -> v.getVillagerBrain().getArmorWear()), (Object)new TriggerCommandInfo("try-go-home", "Try to go to your home in the village if possible", (p, v) -> v.getResidency().goHome((Player)p)), (Object)new TriggerCommandInfo("open-trade-window", "Open the trade menu when the player is interested in trading, wants to check your prices or your inventory.", (p, v) -> v.beginTradeWith((Player)p), (p, v) -> v.hasTradeOffers()));

    public static Optional<TriggerCommandInfo> findCommand(String command, ServerPlayer player, VillagerEntityMCA villagerEntityMCA) {
        for (TriggerCommandInfo commandInfo : triggerCommands) {
            if (!command.equals(commandInfo.command) || commandInfo.isActive != null && !commandInfo.isActive.test(player, villagerEntityMCA)) continue;
            return Optional.of(commandInfo);
        }
        return Optional.empty();
    }
}

