/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.plugins.journeyplugin.core;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.client.properties.CoreProperties;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class MappingTask
implements Runnable {
    LevelChunk chunk;
    ResourceKey<Level> level;

    public MappingTask(LevelChunk chunk, ResourceKey<Level> level) {
        this.chunk = chunk;
        this.level = level;
    }

    @Override
    public void run() {
        boolean biomeAllowed;
        JourneymapClient client = JourneymapClient.getInstance();
        CoreProperties props = client.getCoreProperties();
        boolean surfaceAllowed = FeatureManager.getInstance().isAllowed(Feature.MapSurface);
        boolean cavesAllowed = FeatureManager.getInstance().isAllowed(Feature.MapCaves);
        boolean topoAllowed = FeatureManager.getInstance().isAllowed(Feature.MapTopo) && props.mapTopography.get() != false;
        boolean bl = biomeAllowed = FeatureManager.getInstance().isAllowed(Feature.MapBiome) && props.mapBiome.get() != false;
        if (!(surfaceAllowed || cavesAllowed || topoAllowed || biomeAllowed)) {
            return;
        }
        EntityDTO player = DataCache.getPlayer();
        LivingEntity playerEntity = (LivingEntity)player.entityLivingRef.get();
        if (playerEntity == null) {
            return;
        }
        ObjectArrayList maps = new ObjectArrayList();
        if (surfaceAllowed) {
            maps.add(MapType.day(this.level));
            maps.add(MapType.night(this.level));
        }
        if (cavesAllowed) {
            maps.add(MapType.underground((EntityDTO)player));
        }
        if (biomeAllowed) {
            maps.add(MapType.biome(this.level));
        }
        if (topoAllowed) {
            maps.add(MapType.topo(this.level));
        }
        File file = FileHandler.getJMWorldDir((Minecraft)Minecraft.m_91087_());
        ChunkMD md = new ChunkMD(this.chunk);
        DataCache.INSTANCE.addChunkMD(md);
        for (MapType type : maps) {
            RegionCoord rCoord = RegionCoord.fromChunkPos((File)file, (MapType)type, (int)md.getCoord().f_45578_, (int)md.getCoord().f_45579_);
            RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, type);
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
            try {
                JourneymapClient.getInstance().getChunkRenderController().renderChunk(rCoord, type, md, regionData);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        DataCache.INSTANCE.removeChunkMD(md);
    }
}

