/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking.packets;

import it.unimi.dsi.fastutil.objects.Object2BooleanLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2FloatLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.base.api.TextUtil;
import pregenerator.client.gui.commands.TaskScreen;
import pregenerator.common.deleter.tasks.IDeletionTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.ServerManager;
import pregenerator.common.networking.IPregenPacket;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.misc.PregenAction;

public class TaskPacket {

    public static interface ISpeedReceiver {
        public void acceptSpeedData(Object2FloatMap<ResourceKey<Level>> var1);
    }

    public static interface TaskFunction<T> {
        public T apply(List<ITask> var1, List<IDeletionTask> var2, Object2BooleanMap<UUID> var3);
    }

    public static class AnswerSpeeds
    implements IPregenPacket {
        Object2FloatMap<ResourceKey<Level>> speeds = new Object2FloatLinkedOpenHashMap();

        public AnswerSpeeds() {
        }

        public AnswerSpeeds(Object2FloatMap<ResourceKey<Level>> speeds) {
            this.speeds = speeds;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            IPregenPacket.writeMap(buffer, this.speeds, (K, V) -> K.m_130085_(V.m_135782_()), FriendlyByteBuf::writeFloat);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            IPregenPacket.readMap(buffer, this.speeds, T -> ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)T.m_130281_()), FriendlyByteBuf::readFloat);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof ISpeedReceiver) {
                ((ISpeedReceiver)screen).acceptSpeedData(this.speeds);
            }
        }
    }

    public static class RequestSpeeds
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.m_5661_((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            Object2FloatLinkedOpenHashMap speeds = new Object2FloatLinkedOpenHashMap();
            for (ResourceKey dim : ServerLifecycleHooks.getCurrentServer().m_129784_()) {
                speeds.put((Object)dim, ServerManager.INSTANCE.getChunksPerTick((ResourceKey<Level>)dim));
            }
            NetworkManager.INSTANCE.sendToPlayer(new AnswerSpeeds((Object2FloatMap<ResourceKey<Level>>)speeds), player);
        }
    }

    public static class AnswerTasks
    implements IPregenPacket {
        List<ITask> tasks = new ObjectArrayList();
        List<IDeletionTask> deletions = new ObjectArrayList();
        Object2BooleanMap<UUID> activeTasks = new Object2BooleanLinkedOpenHashMap();

        public AnswerTasks() {
        }

        public AnswerTasks(List<ITask> tasks, List<IDeletionTask> deletions, Object2BooleanMap<UUID> activeTasks) {
            this.tasks = tasks;
            this.deletions = deletions;
            this.activeTasks = activeTasks;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            IPregenPacket.writeCollection(buffer, this.tasks, (T, B) -> B.m_130079_(ITask.saveTask(T)));
            IPregenPacket.writeCollection(buffer, this.deletions, (T, B) -> B.m_130079_(IDeletionTask.saveTask(T)));
            IPregenPacket.writeMap(buffer, this.activeTasks, FriendlyByteBuf::m_130077_, FriendlyByteBuf::writeBoolean);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            IPregenPacket.readCollection(buffer, this.tasks, T -> ITask.loadTask(T.m_130260_()));
            IPregenPacket.readCollection(buffer, this.deletions, T -> IDeletionTask.loadTask(T.m_130260_()));
            IPregenPacket.readMap(buffer, this.activeTasks, FriendlyByteBuf::m_130259_, FriendlyByteBuf::readBoolean);
        }

        @Override
        public void process(Player player) {
            this.processClient();
        }

        @OnlyIn(value=Dist.CLIENT)
        public void processClient() {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof TaskScreen) {
                ((TaskScreen)screen).acceptTasks(this.tasks, this.deletions, this.activeTasks);
            }
        }
    }

    public static class Action
    implements IPregenPacket {
        int action;
        String taskName;

        public Action() {
        }

        public Action(int action, String taskName) {
            this.action = action;
            this.taskName = taskName;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.action);
            buffer.m_130070_(this.taskName);
        }

        @Override
        public void read(FriendlyByteBuf buffer) {
            this.action = buffer.m_130242_();
            this.taskName = buffer.m_130277_();
        }

        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.m_5661_((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            switch (this.action) {
                case 0: {
                    ServerManager.INSTANCE.pauseTask(this.taskName, arg_0 -> ((Player)player).m_213846_(arg_0));
                    break;
                }
                case 1: {
                    ServerManager.INSTANCE.resumeTask(this.taskName, arg_0 -> ((Player)player).m_213846_(arg_0));
                    break;
                }
                case 2: {
                    ServerManager.INSTANCE.stopTask(this.taskName, arg_0 -> ((Player)player).m_213846_(arg_0), false);
                    break;
                }
                case 3: {
                    ServerManager.INSTANCE.continueTask(this.taskName, player.m_20148_(), arg_0 -> ((Player)player).m_213846_(arg_0));
                    break;
                }
                case 4: {
                    ServerManager.INSTANCE.removeTask(this.taskName, arg_0 -> ((Player)player).m_213846_(arg_0));
                }
            }
            NetworkManager.INSTANCE.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }
    }

    public static class RequestTasks
    implements IPregenPacket.IRequestPacket {
        @Override
        public void process(Player player) {
            if (!ChunkPregenerator.canDoAction(player, PregenAction.COMMANDS)) {
                player.m_5661_((Component)TextUtil.translate("network.chunk_pregen.failures.no_permissions"), false);
                return;
            }
            NetworkManager.INSTANCE.sendToPlayer(ServerManager.INSTANCE.getTasks(AnswerTasks::new), player);
        }
    }
}

