/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.networking;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import pregenerator.base.api.TextUtil;

public interface IPregenPacket {
    public static final DecimalFormat NUMBERS = TextUtil.NUMBERS;
    public static final DecimalFormat FLOATING_NUMBERS = TextUtil.FLOATING_NUMBERS;

    public void write(FriendlyByteBuf var1);

    public void read(FriendlyByteBuf var1);

    public void process(Player var1);

    default public boolean requiresMainThread() {
        return true;
    }

    public static <K, V> void writeMap(FriendlyByteBuf buffer, Map<K, V> elements, BiConsumer<FriendlyByteBuf, K> keyWriter, BiConsumer<FriendlyByteBuf, V> valueWriter) {
        buffer.m_130130_(elements.size());
        for (Map.Entry<K, V> entry : elements.entrySet()) {
            keyWriter.accept(buffer, entry.getKey());
            valueWriter.accept(buffer, entry.getValue());
        }
    }

    public static <K, V> void readMap(FriendlyByteBuf buffer, Map<K, V> output, Function<FriendlyByteBuf, K> keyReader, Function<FriendlyByteBuf, V> valueReader) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            K key = keyReader.apply(buffer);
            V value = valueReader.apply(buffer);
            if (key == null || value == null) continue;
            output.put(key, value);
        }
    }

    public static <T> void writeCollection(FriendlyByteBuf buffer, Collection<T> elements, BiConsumer<T, FriendlyByteBuf> action) {
        buffer.m_130130_(elements.size());
        for (T entry : elements) {
            action.accept(entry, buffer);
        }
    }

    public static <T> void writeCollectionReverse(FriendlyByteBuf buffer, Collection<T> elements, BiConsumer<FriendlyByteBuf, T> action) {
        buffer.m_130130_(elements.size());
        for (T entry : elements) {
            action.accept(buffer, (FriendlyByteBuf)entry);
        }
    }

    public static <T> void readCollection(FriendlyByteBuf buffer, Collection<T> output, Function<FriendlyByteBuf, T> parser) {
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            T result = parser.apply(buffer);
            if (result == null) continue;
            output.add(result);
        }
    }

    public static interface IRequestPacket
    extends IPregenPacket {
        @Override
        default public void write(FriendlyByteBuf buffer) {
        }

        @Override
        default public void read(FriendlyByteBuf buffer) {
        }
    }
}

