/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator.tasks;

import java.time.Duration;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcess;
import pregenerator.common.generator.ChunkShapeBuilder;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.BaseTask;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.manager.BenchmarkManager;
import pregenerator.common.manager.IProcess;

public class BenchmarkTask
extends BaseTask {
    boolean small;

    public BenchmarkTask(CompoundTag nbt) {
        super(nbt);
        this.small = nbt.m_128471_("small");
    }

    public BenchmarkTask(String name, ResourceKey<Level> type, boolean small) {
        super(name, type, GenerationType.FAST_CHECK_GEN.getIndex());
        this.small = small;
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public Component getShapeName() {
        return TextUtil.translate("task.chunk_pregen.shape_type.benchmark");
    }

    @Override
    public long getTaskSize() {
        return this.small ? 40000L : 250000L;
    }

    @Override
    public ChunkPos getCenter() {
        return new ChunkPos(0, 0);
    }

    @Override
    public int getMaxRadius() {
        return this.small ? 100 : 200;
    }

    @Override
    public void append(MutableComponent builder) {
        ITask.insert("task.chunk_pregen.task_type", TextUtil.translate("task.chunk_pregen.shape_type.benchmark"), builder, ChatFormatting.DARK_PURPLE);
        ITask.insert("task.chunk_pregen.radius", this.small ? 100 : 250, builder, ChatFormatting.BLUE);
    }

    @Override
    public ChunkProcess createTask(ServerLevel world, IProcess.PrepareProgress progress) {
        progress.setMax(this.getTaskSize());
        ChunkProcess process = new ChunkProcess(world, GenerationType.values()[this.genType]);
        process.init(ChunkShapeBuilder.getSquareShape(0, 0, this.small ? 100 : 250, progress), new ChunkPos(0, 0), this.name, this.task, this.throwEvents, progress);
        return process;
    }

    @Override
    public void onCompletion(Duration terrainTime, Duration lightTime, long totalChunks) {
        BenchmarkManager.INSTANCE.addBenchmarkResult(this.getTaskSize(), totalChunks, lightTime, terrainTime, this.small, (ResourceKey<Level>)this.type);
    }
}

