/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.generator;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.lang3.time.DurationFormatUtils;
import pregenerator.base.api.TextUtil;
import pregenerator.common.generator.ChunkProcessor;
import pregenerator.common.manager.IProcess;
import pregenerator.common.utils.misc.Area;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ChunkLogger {
    Task{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            MutableComponent name = TextUtil.translate("process.chunk_pregen.name", processor.getTaskName()).m_130940_(ChatFormatting.RED);
            MutableComponent shape = TextUtil.translate("process.chunk_pregen.shape", processor.getTask().getShapeName()).m_130940_(ChatFormatting.GOLD);
            text.m_7220_((Component)1.wrap((Component)name)).m_7220_((Component)1.wrap((Component)shape));
        }
    }
    ,
    World{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)2.wrap((Component)TextUtil.translate("task.chunk_pregen.dimension", TextUtil.dimension(processor.getTask().getDimension())).m_130940_(ChatFormatting.GREEN))).m_130946_(" ");
            text.m_7220_((Component)2.wrap((Component)TextUtil.translate("process.chunk_pregen.task_type", processor.process.getTaskType().createText()).m_130940_(ChatFormatting.DARK_AQUA)));
        }
    }
    ,
    TaskInfo{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String terrain = IProcess.NUMBERS.format(processor.gen_speed.getLastValue());
            String light = IProcess.NUMBERS.format(processor.light_speed.getLastValue());
            String total = IProcess.NUMBERS.format(processor.process.getTotalChunks());
            text.m_7220_((Component)3.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.task_full" : "process.chunk_pregen.task_part", terrain, light, total).m_130940_(ChatFormatting.BLUE)));
            if (processor.process.isValidating()) {
                text.m_7220_((Component)TextUtil.translate("process.chunk_pregen.logger_split"));
                long[] progress = processor.process.getValidationProgress();
                text.m_7220_((Component)3.wrap((Component)TextUtil.translate("process.chunk_pregen.validation", IProcess.NUMBERS.format(progress[0]), IProcess.NUMBERS.format(progress[1]))));
            }
        }
    }
    ,
    ProcessingSpeed{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String main = IProcess.FLOATING_NUMBERS.format(processor.mainQueue.isNotWorking() && processor.process.isDone() ? 0.0 : (double)processor.gen_speed.getTotalValue());
            String light = IProcess.FLOATING_NUMBERS.format(processor.lightQueue.isNotWorking() ? 0.0 : (double)processor.light_speed.getTotalValue());
            text.m_7220_((Component)4.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.speed_full" : "process.chunk_pregen.speed_part", main, light).m_130940_(ChatFormatting.AQUA)));
        }
    }
    ,
    LoadedFiles{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            text.m_7220_((Component)5.wrap((Component)TextUtil.translate("process.chunk_pregen.world_loaded_data", processor.process.getLoadedChunks(), processor.process.getActiveRegionFiles(), processor.process.getPointsOfInterest()).m_130940_(ChatFormatting.GOLD)));
        }
    }
    ,
    workingArea{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            Area area = processor.lightQueue.getWorkingArea();
            if (area != null) {
                text.m_7220_((Component)6.wrap((Component)TextUtil.translate("process.chunk_pregen.working_area", area.getMinX(), area.getMinZ(), area.getMaxX(), area.getMaxZ()).m_130940_(ChatFormatting.RED)));
            } else {
                text.m_7220_((Component)6.wrap((Component)TextUtil.translate("process.chunk_pregen.working_area.fetching").m_6879_().m_130940_(ChatFormatting.RED)));
            }
        }
    }
    ,
    ExpectedTime{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            long total = processor.process.getTotalChunks();
            String main = this.getTime((long)((float)(total - processor.normalDone) / processor.gen_speed.getTotalValue()) * 50L);
            String light = this.getTime((long)((float)(total - processor.lightDone) / processor.light_speed.getTotalValue()) * 50L);
            text.m_7220_((Component)7.wrap((Component)TextUtil.translate(processor.isMultithreaded() ? "process.chunk_pregen.time_full" : "process.chunk_pregen.time_part", main, light, processor.getTime()).m_130940_(ChatFormatting.GREEN)));
        }
    }
    ,
    RamUsage{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            ServerLevel level = processor.process.getWorld();
            text.m_7220_((Component)8.wrap((Component)TextUtil.ram().m_130940_(ChatFormatting.LIGHT_PURPLE)));
            text.m_7220_((Component)8.wrap((Component)TextUtil.translate("process.chunk_pregen.ticks", level.m_183326_().m_183574_(), level.m_183324_().m_183574_()).m_130940_(ChatFormatting.BLUE)));
        }
    }
    ,
    Controls{

        @Override
        public void append(MutableComponent text, ChunkProcessor processor) {
            String pause = "/pregen pause " + processor.getTaskName();
            String resume = "/pregen resume " + processor.getTaskName();
            String unlisten = "/pregen info unlisten";
            String listen = "/pregen info listen";
            String stop = "/pregen stop " + processor.getTaskName();
            String cont = "/pregen continue " + processor.getTaskName();
            String delete = "/pregen stop " + processor.getTaskName() + " true";
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.listen").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, listen)).m_131140_(ChatFormatting.GREEN))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.mute").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, unlisten)).m_131140_(ChatFormatting.RED))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.pause").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, pause)).m_131140_(ChatFormatting.AQUA))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.resume").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, resume)).m_131140_(ChatFormatting.BLUE))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.stop").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, stop)).m_131140_(ChatFormatting.YELLOW))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.continue").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, cont)).m_131140_(ChatFormatting.DARK_AQUA))));
            text.m_7220_((Component)9.wrap((Component)TextUtil.translate("process.chunk_pregen.actions.remove").m_6879_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, delete)).m_131140_(ChatFormatting.GOLD))));
        }
    };


    public static MutableComponent wrap(Component text) {
        return TextUtil.translate("process.chunk_pregen.wrap", text);
    }

    protected String getTime(long time) {
        return DurationFormatUtils.formatDuration((long)Math.abs(time), (String)"HH:mm:ss");
    }

    public void append(MutableComponent text, ChunkProcessor processor) {
    }
}

