/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.client.gui.commands;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import pregenerator.base.api.Align;
import pregenerator.base.api.TextUtil;
import pregenerator.base.impl.BasePregenScreen;
import pregenerator.base.impl.comp.CycleButton;
import pregenerator.base.impl.comp.PregenButton;
import pregenerator.base.impl.comp.PregenText;
import pregenerator.client.gui.RetrogenScreen;
import pregenerator.common.generator.GenerationType;
import pregenerator.common.generator.tasks.ITask;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.networking.packets.CommandPacket;
import pregenerator.common.networking.packets.MemoryPacket;
import pregenerator.common.networking.packets.TaskPacket;
import pregenerator.common.utils.misc.GenShape;
import pregenerator.common.utils.misc.LongEaser;

public class GenCommandScreen
extends BasePregenScreen
implements MemoryPacket.IMemoryReceiver,
TaskPacket.ISpeedReceiver {
    Screen parent;
    protected int xOff = 0;
    protected CycleButton.CycleState<Integer> type = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getTypeName, 0, 1, 2);
    protected CycleButton.CycleState<GenShape> shape = new CycleButton.CycleState<GenShape>(GenShape.SQUARE, GenShape::getName, GenShape.values());
    protected PregenText.TextState startX = new PregenText.TextState("0", this.number(false));
    protected CycleButton.CycleState<Boolean> startXType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> startXRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState startZ = new PregenText.TextState("0", this.number(false));
    protected CycleButton.CycleState<Boolean> startZType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> startZRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState endX = new PregenText.TextState("100", this.number(true));
    protected CycleButton.CycleState<Boolean> endXType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> endXRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected PregenText.TextState endZ = new PregenText.TextState("200", this.number(true));
    protected CycleButton.CycleState<Boolean> endZType = new CycleButton.CycleState<Boolean>(Boolean.valueOf(true), this::getNumberName, true, false);
    protected CycleButton.CycleState<Integer> endZRelation = new CycleButton.CycleState<Integer>(Integer.valueOf(0), this::getRelationName, 0, 1, 2);
    protected CycleButton.CycleState<ResourceKey<Level>> dimension = new CycleButton.CycleState<ResourceKey<Level>>(Level.f_46428_, TextUtil::dimension, this.dimensions());
    protected PregenText.TextState taskName = new PregenText.TextState("", T -> !T.contains(" "), "ExampleTask");
    protected CycleButton.CycleState<GenerationType> generationType = new CycleButton.CycleState<GenerationType>(GenerationType.FAST_CHECK_GEN, GenerationType::createText, GenerationType.values());
    protected PregenButton retrogenSelector;
    protected PregenButton startGen;
    protected PregenButton cancel;
    boolean advanced = false;
    long expectedChunks = 0L;
    long mb = 0L;
    long free = -1L;
    LongEaser progress = new LongEaser(0L);
    Object2FloatMap<ResourceKey<Level>> speeds = new Object2FloatOpenHashMap();

    public GenCommandScreen(Screen parent) {
        super((Component)TextUtil.guiConstructor());
        this.parent = parent;
        this.sendToServer(new MemoryPacket.RequestFree());
        this.sendToServer(new TaskPacket.RequestSpeeds());
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.cycleButton(-90 + this.xOff, -82, 80, 12, Align.CENTER, Align.CENTER, this.type, (CycleButton<T> T) -> this.updateTaskMode());
        this.cycleButton(0 + this.xOff, -82, 80, 12, Align.CENTER, Align.CENTER, this.shape, this.emptyAction());
        this.text(-90 + this.xOff, -49, 55, 12, Align.CENTER, Align.CENTER, this.startX);
        this.cycleButton(-33 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startXType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(-20 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startXRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-1 + this.xOff, -49, 55, 12, Align.CENTER, Align.CENTER, this.startZ);
        this.cycleButton(56 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startZType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(69 + this.xOff, -49, 12, 12, Align.CENTER, Align.CENTER, this.startZRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-90 + this.xOff, -24, 55, 12, Align.CENTER, Align.CENTER, this.endX);
        this.cycleButton(-33 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endXType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(-20 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endXRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.text(-1 + this.xOff, -24, 55, 12, Align.CENTER, Align.CENTER, this.endZ);
        this.cycleButton(56 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endZType, this.emptyAction()).setTooltip(this::getPositionValue);
        this.cycleButton(69 + this.xOff, -24, 12, 12, Align.CENTER, Align.CENTER, this.endZRelation, this.emptyAction()).setTooltip(this::getRelationValue);
        this.cycleButton(-90 + this.xOff, 4, 170, 12, Align.CENTER, Align.CENTER, this.dimension, this.emptyAction()).withSelectScreen().setTooltip(this::getDimensionTooltip);
        this.text(-90 + this.xOff, 28, 80, 12, Align.CENTER, Align.CENTER, this.taskName);
        this.button(0 + this.xOff, 28, 80, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.adv"), T -> {
            this.generationType.getOwner().f_93624_ = this.advanced = !this.advanced;
            this.updateRetrogenMode();
        });
        this.cycleButton(-90 + this.xOff, 58, 100, 12, Align.CENTER, Align.CENTER, this.generationType, (CycleButton<T> T) -> this.updateRetrogenMode()).withSelectScreen().setTooltip(this::getGenerationType);
        this.retrogenSelector = this.button(20 + this.xOff, 58, 60, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.select"), this::openRetrogen);
        this.generationType.getOwner().f_93624_ = this.advanced;
        this.startGen = this.button(-90 + this.xOff, 93, 80, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.start"), this::startTask).setTooltip(this::getValdiationScan);
        this.cancel = this.button(0 + this.xOff, 93, 80, 12, Align.CENTER, Align.CENTER, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.cancel"), T -> this.m_7379_());
        this.updateTaskMode();
        this.updateRetrogenMode();
    }

    private void startTask(Button button) {
        ITask task = this.createTask();
        if (task == null) {
            return;
        }
        NetworkManager.INSTANCE.sendToServer(new CommandPacket.GenTask(task));
        this.setScreen(null);
    }

    void openRetrogen(Button button) {
        this.setScreen(new RetrogenScreen(this));
    }

    public void m_7379_() {
        this.setScreen(this.parent);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        ITask task = this.createTask();
        this.expectedChunks = task == null ? 0L : task.getTaskSize();
        this.mb = TextUtil.getWorldSize(this.expectedChunks, this.dimension.getValue());
        this.updateProgress();
        if (this.tick % 80 == 0) {
            this.sendToServer(new TaskPacket.RequestSpeeds());
        }
    }

    private void updateProgress() {
        if (this.free == -1L) {
            return;
        }
        if (this.free == 0L) {
            this.progress.set(0L);
            return;
        }
        if (this.mb < 0L) {
            this.progress.set(Long.MAX_VALUE);
            return;
        }
        this.progress.set((long)((double)this.mb / (double)this.free * 1000000.0));
    }

    @Override
    public void acceptSpeedData(Object2FloatMap<ResourceKey<Level>> speeds) {
        this.speeds.clear();
        this.speeds.putAll(speeds);
    }

    @Override
    public void receivedMemory(ResourceKey<Level> dimension, long value, boolean free) {
        if (free) {
            this.free = value;
        }
    }

    protected void renderFrame(GuiGraphics graphics) {
        this.drawSimpleRect(graphics, this.centerX - 100, this.centerY - 105, this.centerX + 90, this.centerY + 110, -3750202, false);
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.progress.tick(partialTicks);
        this.startGen.f_93623_ = this.updateValidity();
        this.m_280273_(graphics);
        this.renderFrame(graphics);
        this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY - 59, this.centerX + 83 + this.xOff, this.centerY - 9, -3750202, true);
        if (this.advanced) {
            this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY + 54, this.centerX + 83 + this.xOff, this.centerY + 73, -3750202, true);
        }
        int y = this.advanced ? 76 : 44;
        this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY + y, this.centerX + 83 + this.xOff, this.centerY + y + 12, -7631989, true);
        if (!this.advanced) {
            this.drawSimpleRect(graphics, this.centerX - 93 + this.xOff, this.centerY + 58, this.centerX + 83 + this.xOff, this.centerY + 58 + 12, -7631989, true);
        }
        if (this.free == -1L) {
            return;
        }
        double value = Math.max(Math.min((double)this.progress.get() / 1000000.0, 1.0), 0.0);
        graphics.m_280509_(this.centerX - 93 + this.xOff, this.centerY + y, this.centerX + 83 - (int)(176.0 - 176.0 * value) + this.xOff, this.centerY + y + 12, -16731648);
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.title"), 0.0f, -102.0f, Align.CENTER, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.task_type"), -90 + this.xOff, -91.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.shape"), this.xOff, -91.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.positioning"), -93 + this.xOff, -68.0f, Align.START, 0x404040);
        if (this.type.getValue() == 2) {
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.from_x"), -90 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.from_z"), -1 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.to_x"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.to_z"), -1 + this.xOff, -33.0f, Align.START, 0x404040);
        } else {
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.center_x"), -90 + this.xOff, -58.0f, Align.START, 0x404040);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.center_z"), -1 + this.xOff, -58.0f, Align.START, 0x404040);
            if (this.type.getValue() == 1) {
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.min_radius"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.max_radius"), -1 + this.xOff, -33.0f, Align.START, 0x404040);
            } else {
                this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.radius"), -90 + this.xOff, -33.0f, Align.START, 0x404040);
            }
        }
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.dimension"), -90 + this.xOff, -5.0f, Align.START, 0x404040);
        this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.task_name"), -90 + this.xOff, 19.0f, Align.START, 0x404040);
        if (this.advanced) {
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.gen_type"), -93 + this.xOff, 44.0f, Align.START, 0x404040);
        }
        int y = this.advanced ? 78 : 46;
        String key = this.free == -1L ? "gui.chunk_pregen.taskgenerator.disk_usage.fetching" : "gui.chunk_pregen.taskgenerator.disk_usage";
        this.drawText(graphics, (Component)TextUtil.translate(key, TextUtil.findBestMemory(this.mb), TextUtil.findBestMemory(this.free)), -5 + this.xOff, y, Align.CENTER, 0x404040);
        if (!this.advanced) {
            float speed = this.speeds.getFloat(this.dimension.getValue());
            long time = (long)((float)this.expectedChunks / speed * 50.0f);
            this.drawText(graphics, (Component)TextUtil.translate("gui.chunk_pregen.task_screen.nodes.eta", TextUtil.getTime(time), FLOATING_NUMBERS.format(speed)), -5 + this.xOff, 60.0f, Align.CENTER, 0x404040);
        }
    }

    private void updateRetrogenMode() {
        this.retrogenSelector.f_93624_ = this.advanced && this.generationType.getValue() == GenerationType.RETROGEN;
    }

    private void updateTaskMode() {
        boolean value = this.type.getValue() < 2;
        this.endZ.getOwner().f_93624_ = this.type.getValue() >= 1;
        this.endZType.getOwner().f_93624_ = this.type.getValue() >= 1;
        this.endZRelation.getOwner().f_93624_ = this.type.getValue() >= 2;
        this.endXRelation.getOwner().f_93624_ = this.type.getValue() >= 2;
        this.endX.setFilter(this.number(value), value ? "100" : "0");
        this.endZ.setFilter(this.number(value), value ? "200" : "0");
    }

    protected boolean updateValidity() {
        boolean valid = true;
        valid &= !this.taskName.getValue().isEmpty();
        switch (this.type.getValue()) {
            case 0: {
                valid &= this.getValue(this.endX, this.endXType, this.endXRelation, false, true) >= 0;
                break;
            }
            case 1: {
                valid &= this.getValue(this.endX, this.endXType, this.endXRelation, false, true) < this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                break;
            }
            case 2: {
                valid &= this.getValue(this.startX, this.startXType, this.startXRelation, true, true) < this.getValue(this.endX, this.endXType, this.endXRelation, true, true) && this.getValue(this.startZ, this.startZType, this.startZRelation, true, false) < this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
            }
        }
        valid &= this.mb < this.free;
        return valid &= !this.isToManyChunks(this.expectedChunks);
    }

    public int getValue(PregenText.TextState state, CycleButton.CycleState<Boolean> chunks, CycleButton.CycleState<Integer> relative, boolean isPosition, boolean x) {
        int value = this.parseNumber(state.getValue());
        if (!chunks.getValue().booleanValue()) {
            value >>= 4;
        }
        return value + (!isPosition ? 0 : this.getRelativeLocation(relative, x));
    }

    private int getRelativeLocation(CycleButton.CycleState<Integer> relative, boolean x) {
        switch (relative.getValue()) {
            case 1: {
                return x ? this.f_96541_.f_91074_.m_20183_().m_123341_() >> 4 : this.f_96541_.f_91074_.m_20183_().m_123343_() >> 4;
            }
            case 2: {
                return x ? this.f_96541_.f_91073_.m_220360_().m_123341_() >> 4 : this.f_96541_.f_91073_.m_220360_().m_123343_() >> 4;
            }
        }
        return 0;
    }

    private int parseNumber(String value) {
        if (value.isEmpty() || "-".equals(value)) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public ITask createTask() {
        switch (this.type.getValue()) {
            case 0: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                return this.shape.getValue().createRadiusGenTask(this.taskName.getValue(), x, z, radius, this.generationType.getValue(), this.dimension.getValue());
            }
            case 1: {
                int x = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int z = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int minRadius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                int maxRadius = this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                return this.shape.getValue().createExpansionGenTask(this.taskName.getValue(), x, z, Math.min(minRadius, maxRadius), Math.max(minRadius, maxRadius), this.generationType.getValue(), this.dimension.getValue());
            }
            case 2: {
                int minX = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int minZ = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int maxX = this.getValue(this.endX, this.endXType, this.endXRelation, true, true);
                int maxZ = this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
                return this.shape.getValue().createAreaGenTask(this.taskName.getValue(), new ChunkPos(Math.min(minX, maxX), Math.min(minZ, maxZ)), new ChunkPos(Math.max(minX, maxX), Math.max(minZ, maxZ)), this.generationType.getValue(), this.dimension.getValue());
            }
        }
        return null;
    }

    private Component getValdiationScan(PregenButton button) {
        MutableComponent comp = TextUtil.empty();
        if (this.taskName.getValue().isEmpty()) {
            comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.task_name"));
        }
        switch (this.type.getValue()) {
            case 0: {
                int radius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                if (radius > 0) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.radius_to_small"));
                break;
            }
            case 1: {
                int minRadius = this.getValue(this.endX, this.endXType, this.endXRelation, false, true);
                int maxRadius = this.getValue(this.endZ, this.endZType, this.endZRelation, false, false);
                if (minRadius < maxRadius) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_bigger_max"));
                break;
            }
            case 2: {
                int minX = this.getValue(this.startX, this.startXType, this.startXRelation, true, true);
                int minZ = this.getValue(this.startZ, this.startZType, this.startZRelation, true, false);
                int maxX = this.getValue(this.endX, this.endXType, this.endXRelation, true, true);
                int maxZ = this.getValue(this.endZ, this.endZType, this.endZRelation, true, false);
                if (minX >= maxX) {
                    if (!comp.m_7360_().isEmpty()) {
                        comp.m_130946_("\n");
                    }
                    comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_x_bigger_max"));
                }
                if (minZ < maxZ) break;
                if (!comp.m_7360_().isEmpty()) {
                    comp.m_130946_("\n");
                }
                comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.min_z_bigger_max"));
                break;
            }
        }
        if (this.mb >= this.free) {
            if (!comp.m_7360_().isEmpty()) {
                comp.m_130946_("\n");
            }
            comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.out_of_storage"));
        }
        if (this.isToManyChunks(this.expectedChunks)) {
            if (!comp.m_7360_().isEmpty()) {
                comp.m_130946_("\n");
            }
            comp.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.error.million_limit"));
        }
        return comp.m_7360_().isEmpty() ? null : comp;
    }

    protected boolean isToManyChunks(long chunks) {
        return chunks > 1000000L;
    }

    private Component getDimensionTooltip(CycleButton<ResourceKey<Level>> button) {
        MutableComponent base = TextUtil.empty();
        base.m_7220_((Component)TextUtil.translateStyled("gui.chunk_pregen.taskgenerator.tooltip.dimension", ChatFormatting.GOLD)).m_130946_("\n");
        base.m_7220_((Component)TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.mod", TextUtil.getModName(button.getValue().m_135782_().m_135827_())).m_130940_(ChatFormatting.GRAY));
        return base;
    }

    private Component getGenerationType(CycleButton<GenerationType> value) {
        return value.getValue().createSuggestion();
    }

    private Component getPositionValue(CycleButton<Boolean> value) {
        return TextUtil.translate(value.getValue() != false ? "gui.chunk_pregen.taskgenerator.tooltip.count_chunks" : "gui.chunk_pregen.taskgenerator.tooltip.count_blocks");
    }

    private Component getRelationValue(CycleButton<Integer> value) {
        return TextUtil.translate(value.getValue() == 0 ? "gui.chunk_pregen.taskgenerator.tooltip.value_literal" : (value.getValue() == 1 ? "gui.chunk_pregen.taskgenerator.tooltip.value_player" : "gui.chunk_pregen.taskgenerator.tooltip.value_spawn"));
    }

    private Predicate<String> number(boolean positive) {
        return T -> {
            if (T.isEmpty() || !positive && "-".equals(T)) {
                return true;
            }
            try {
                int value = Integer.parseInt(T);
                return !positive || value >= 0;
            }
            catch (Exception e) {
                return false;
            }
        };
    }

    private Component getNumberName(boolean value) {
        return TextUtil.literal(value ? "C" : "B");
    }

    private Component getRelationName(int value) {
        return TextUtil.literal(value == 0 ? "L" : (value == 1 ? "P" : "S"));
    }

    private Component getTypeName(int value) {
        switch (value) {
            case 1: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.expansion");
            }
            case 2: {
                return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.area");
            }
        }
        return TextUtil.translate("gui.chunk_pregen.taskgenerator.tooltip.type.radius");
    }
}

