/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.util.contract;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.event.EventResult;
import dev.architectury.platform.Platform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.satisfy.wildernature.client.gui.handlers.BountyBlockScreenHandler;
import net.satisfy.wildernature.item.ContractItem;
import net.satisfy.wildernature.util.contract.Contract;

public class ContractInProgress {
    public static final HashMap<UUID, ContractInProgress> progressPerPlayer = new HashMap();
    public static final long EXPIRY_TICKS = 72000L;
    public final ResourceLocation contractResource;
    public final long boardId;
    public int count;
    public final long startTick;
    public static final Codec<ContractInProgress> SERVER_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("contract").forGetter(ContractInProgress::getContractResource), (App)Codec.INT.fieldOf("count").forGetter(ContractInProgress::getCount), (App)Codec.LONG.fieldOf("id").forGetter(ContractInProgress::getId), (App)Codec.LONG.fieldOf("start_tick").forGetter(progress -> progress.startTick)).apply((Applicative)instance, ContractInProgress::new));

    private static ResourceLocation getContractResource(ContractInProgress progress) {
        return progress.contractResource;
    }

    private static long getId(Object o) {
        return ((ContractInProgress)o).boardId;
    }

    private static int getCount(Object o) {
        return ((ContractInProgress)o).count;
    }

    public ContractInProgress(ResourceLocation contract, int count, long id, long startTick) {
        this.contractResource = contract;
        this.boardId = id;
        this.count = count;
        this.startTick = startTick;
    }

    public static ContractInProgress newInstance(ResourceLocation contract, int count, long boardId, long startTick) {
        return new ContractInProgress(contract, count, boardId, startTick);
    }

    public boolean isFinished() {
        return this.count <= 0;
    }

    public static EventResult onEntityDeath(LivingEntity entity, DamageSource damageSource) {
        ServerPlayer player;
        ContractInProgress contract;
        Entity attacker = damageSource.m_7639_();
        if (attacker instanceof ServerPlayer && (contract = progressPerPlayer.get((player = (ServerPlayer)attacker).m_20148_())) != null) {
            contract.onEntityDeath(entity, damageSource, (Player)player);
        }
        return EventResult.pass();
    }

    public void onEntityDeath(LivingEntity entity, DamageSource damageSource, Player player) {
        Contract contract = this.getContract();
        try {
            boolean targetMatches;
            boolean damageResult;
            if (this.isFinished()) {
                return;
            }
            LootParams lootParams = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20318_(0.0f)).m_287289_(LootContextParams.f_81455_, (Object)entity).m_287235_(LootContextParamSets.f_81412_);
            LootContext context = new LootContext.Builder(lootParams).m_287259_(null);
            LootItemCondition condition = (LootItemCondition)Objects.requireNonNull(entity.m_20194_()).m_278653_().m_278789_(LootDataType.f_278407_, contract.targetPredicate());
            boolean result = condition != null && condition.test((Object)context);
            LootParams damageParams = new LootParams.Builder((ServerLevel)entity.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20318_(0.0f)).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287286_(LootContextParams.f_81458_, (Object)damageSource.m_7639_()).m_287286_(LootContextParams.f_81459_, (Object)damageSource.m_7640_()).m_287286_(LootContextParams.f_81456_, (Object)player).m_287235_(LootContextParamSets.f_81415_);
            LootContext damageContext = new LootContext.Builder(damageParams).m_287259_(null);
            LootItemCondition damageCondition = (LootItemCondition)entity.m_20194_().m_278653_().m_278789_(LootDataType.f_278407_, contract.damagePredicate());
            boolean bl = damageResult = damageCondition == null || damageCondition.test((Object)damageContext);
            if (damageCondition == null) {
                player.m_213846_((Component)Component.m_237113_((String)("Data error: contract " + this.contractResource + " has wrong damage predicate id (" + contract.damagePredicate() + "). Please check if name is correct")));
                return;
            }
            boolean bl2 = targetMatches = result || BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_()).equals((Object)contract.targetPredicate());
            if (Platform.isDevelopmentEnvironment()) {
                player.m_213846_((Component)Component.m_237113_((String)("_entity: " + targetMatches + "; damage: " + damageResult)));
            }
            if (targetMatches && damageResult) {
                --this.count;
            }
            if (Platform.isDevelopmentEnvironment()) {
                player.m_213846_((Component)Component.m_237113_((String)("_Entities left: " + this.count)));
            }
            if (this.isFinished() && Platform.isDevelopmentEnvironment()) {
                player.m_213846_((Component)Component.m_237113_((String)("_Finished contract \"" + contract.name() + "\"")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Objects.requireNonNull(player.m_20194_()).m_7570_(false);
        }
    }

    public String toString() {
        return "[" + this.boardId + ", " + this.contractResource.toString() + ", " + this.count + "]";
    }

    public void onFinish(ServerPlayer player) {
        MinecraftServer server = player.f_8924_;
        server.execute(() -> {
            BountyBlockScreenHandler bountyHandler = (BountyBlockScreenHandler)player.f_36096_;
            if (bountyHandler.targetEntity.boardId == this.boardId) {
                bountyHandler.targetEntity.addXp(this.getContract().reward().blockExpReward());
            } else if (Platform.isDevelopmentEnvironment()) {
                player.m_213846_((Component)Component.m_237113_((String)"_not given xp to block because contract taken in other board"));
            }
            if (this.getContract().reward().playerRewardLoot().isEmpty()) {
                return;
            }
            Objects.requireNonNull(player.m_9236_().m_7654_()).m_278653_().m_278676_(this.getContract().reward().playerRewardLoot().get()).m_287276_(new LootParams.Builder((ServerLevel)player.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20318_(0.0f)).m_287235_(LootContextParamSets.f_81418_), player.m_287233_(), arg_0 -> ((ServerPlayer)player).m_19983_(arg_0));
        });
    }

    public Contract getContract() {
        return Contract.fromId(this.contractResource);
    }

    public static void onServerTick(MinecraftServer server) {
        long currentTick = server.m_129783_().m_46467_();
        Iterator<Map.Entry<UUID, ContractInProgress>> iterator = progressPerPlayer.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ContractInProgress> entry = iterator.next();
            UUID playerId = entry.getKey();
            ContractInProgress progress = entry.getValue();
            if (currentTick - progress.startTick < 72000L) continue;
            ServerPlayer player = server.m_6846_().m_11259_(playerId);
            if (player != null) {
                ContractInProgress.removeContractItem(player, "text.gui.wildernature.bounty.contract_expired");
            }
            iterator.remove();
        }
    }

    public static void removeContractItem(ServerPlayer player, String messageKey) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!(stack.m_41720_() instanceof ContractItem) || !stack.m_41782_()) continue;
            assert (stack.m_41783_() != null);
            if (!stack.m_41783_().m_128342_("player_uuid").equals(player.m_20148_())) continue;
            player.m_150109_().m_36057_(stack);
            player.m_213846_((Component)Component.m_237115_((String)messageKey));
            break;
        }
    }
}

