/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.wildernature.client.gui.screens;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public abstract class CompendiumScreen
extends Screen {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("wildernature:textures/gui/compendium/page1.png"), new ResourceLocation("wildernature:textures/gui/compendium/page2.png"), new ResourceLocation("wildernature:textures/gui/compendium/page3.png"), new ResourceLocation("wildernature:textures/gui/compendium/page4.png"), new ResourceLocation("wildernature:textures/gui/compendium/page5.png"), new ResourceLocation("wildernature:textures/gui/compendium/page6.png")};
    private static final PageData[] PAGES = new PageData[]{new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page1_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page1_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page1_left_spawns", 54, 139, 111, 156), new TooltipData("compendium.wildernature.page1_right_health", 184, 103, 281, 113), new TooltipData("compendium.wildernature.page1_right_alignment", 184, 27, 201, 89), new TooltipData("compendium.wildernature.page1_right_spawns", 214, 139, 251, 156)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page1_squirrel", 62, 126), new FixedTextData("compendium.wildernature.page1_raccoon", 212, 126)}), new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page2_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page2_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page2_left_spawns", 74, 139, 91, 156), new TooltipData("compendium.wildernature.page2_right_health", 184, 103, 281, 113), new TooltipData("compendium.wildernature.page2_right_alignment", 184, 27, 201, 89), new TooltipData("compendium.wildernature.page2_right_spawns", 224, 139, 241, 156)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page2_red_wolf", 62, 126), new FixedTextData("compendium.wildernature.page2_minisheep", 212, 126)}), new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page3_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page3_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page3_left_spawns", 64, 139, 101, 156), new TooltipData("compendium.wildernature.page3_right_health", 184, 103, 281, 113), new TooltipData("compendium.wildernature.page3_right_alignment", 184, 27, 201, 89), new TooltipData("compendium.wildernature.page3_right_spawns", 224, 139, 241, 156)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page3_boar", 72, 126), new FixedTextData("compendium.wildernature.page3_owl", 225, 126)}), new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page4_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page4_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page4_left_spawns", 74, 139, 91, 156), new TooltipData("compendium.wildernature.page4_right_health", 184, 103, 281, 113), new TooltipData("compendium.wildernature.page4_right_alignment", 184, 27, 201, 89)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page4_deer", 72, 126), new FixedTextData("compendium.wildernature.page4_dog", 225, 126)}), new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page5_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page5_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page5_left_spawns", 54, 139, 111, 156), new TooltipData("compendium.wildernature.page5_right_health", 184, 103, 281, 113), new TooltipData("compendium.wildernature.page5_right_alignment", 184, 27, 201, 89), new TooltipData("compendium.wildernature.page5_right_spawns", 224, 139, 241, 156)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page5_turkey", 65, 126), new FixedTextData("compendium.wildernature.page5_bison", 220, 126)}), new PageData(new TooltipData[]{new TooltipData("compendium.wildernature.page6_left_health", 34, 101, 131, 113), new TooltipData("compendium.wildernature.page6_left_alignment", 34, 27, 51, 80), new TooltipData("compendium.wildernature.page6_left_spawns", 64, 139, 101, 156)}, new FixedTextData[]{new FixedTextData("compendium.wildernature.page6_pelican", 65, 126)})};
    private int currentPage = 0;

    protected CompendiumScreen() {
        super((Component)Component.m_237115_((String)"compendium.wildernature.title"));
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        int textureWidth = 316;
        int textureHeight = 190;
        int x = (this.f_96543_ - textureWidth) / 2;
        int y = (this.f_96544_ - textureHeight) / 2;
        guiGraphics.m_280163_(TEXTURES[this.currentPage], x, y, 0.0f, 0.0f, textureWidth, textureHeight, textureWidth, textureHeight);
        PageData pageData = PAGES[this.currentPage];
        for (TooltipData tooltipData : pageData.tooltips()) {
            if (!this.isMouseOverArea(mouseX, mouseY, x + tooltipData.x1(), y + tooltipData.y1(), x + tooltipData.x2(), y + tooltipData.y2())) continue;
            MutableComponent tooltipText = Component.m_237115_((String)tooltipData.text());
            guiGraphics.m_280557_(this.f_96547_, (Component)tooltipText, mouseX, mouseY);
        }
        for (Record record : pageData.fixedTexts()) {
            MutableComponent fixedText = Component.m_237115_((String)((FixedTextData)record).text());
            guiGraphics.m_280430_(this.f_96547_, (Component)fixedText, x + ((FixedTextData)record).x(), y + ((FixedTextData)record).y(), 0xFFFFFF);
        }
        if (this.currentPage < TEXTURES.length - 1 && this.isMouseOverArea(mouseX, mouseY, 356, 43, 371, 227)) {
            guiGraphics.m_280509_(356, 43, 371, 227, Integer.MIN_VALUE);
        }
        if (this.currentPage > 0 && this.isMouseOverArea(mouseX, mouseY, 61, 43, 76, 227)) {
            guiGraphics.m_280509_(61, 43, 76, 227, Integer.MIN_VALUE);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.currentPage < TEXTURES.length - 1 && this.isMouseOverArea((int)mouseX, (int)mouseY, 356, 43, 371, 227)) {
            this.nextPage();
            return true;
        }
        if (this.currentPage > 0 && this.isMouseOverArea((int)mouseX, (int)mouseY, 61, 43, 76, 227)) {
            this.previousPage();
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private boolean isMouseOverArea(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    @NotNull
    public Component m_96636_() {
        return Component.m_237115_((String)"compendium.wildernature.title");
    }

    public void nextPage() {
        if (this.currentPage < TEXTURES.length - 1) {
            ++this.currentPage;
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
    }

    private record PageData(TooltipData[] tooltips, FixedTextData[] fixedTexts) {
    }

    private record TooltipData(String text, int x1, int y1, int x2, int y2) {
    }

    private record FixedTextData(String text, int x, int y) {
    }
}

