/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.config;

import io.github.bumblesoftware.fastload.config.DefaultConfig;
import io.github.bumblesoftware.fastload.config.FLMath;
import io.github.bumblesoftware.fastload.init.Fastload;
import io.github.bumblesoftware.fastload.util.Bound;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.minecraftforge.fml.loading.FMLPaths;

public class FLConfig {
    private static final Properties properties = new Properties();
    private static final Path path = FMLPaths.CONFIGDIR.get().resolve("Fastload".toLowerCase() + ".properties");

    public static void init() {
    }

    protected static boolean getRawDebug() {
        return FLConfig.getBoolean("debug", false);
    }

    protected static boolean getRawInstantLoad() {
        return FLConfig.getBoolean("instant_load", false);
    }

    protected static int getRawChunkTryLimit() {
        return FLConfig.getInt("chunk_try_limit", 250, DefaultConfig.CHUNK_TRY_LIMIT_BOUND);
    }

    protected static int getRawLocalRenderChunkRadius() {
        return FLConfig.getInt(DefaultConfig.LOCAL_RENDER_RADIUS_KEY, 10, DefaultConfig.LOCAL_CHUNK_RADIUS_BOUND);
    }

    protected static int getRawServerRenderChunkRadius() {
        return FLConfig.getInt(DefaultConfig.SERVER_RENDER_RADIUS_KEY, 3, DefaultConfig.SERVER_CHUNK_RADIUS_BOUND);
    }

    private static void logWarn(String key) {
        Fastload.LOGGER.warn("Failed to parse variable '" + key + "' in Fastload's config, generating a new one!");
    }

    public static void writeToDisk() {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            properties.store(out, "Fastload Configuration File");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter comment = Files.newBufferedWriter(path, StandardOpenOption.APPEND, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            comment.write("\n# Definitions");
            comment.write("\n# " + FLConfig.writable("debug") + " = debug (logWarn) all things happening in fastload to aid in diagnosing issues.");
            comment.write("\n# Enabled = true, Disabled = false");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable("chunk_try_limit") + " = how many times in a row should the same count of loaded chunks be ignored before we cancel pre-rendering.");
            comment.write("\n# Min = 1, Max = 1000. Set 1000 for infinity");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable("instant_load") + " = should fastload just nuke the downloading terrain screen? This boolean is for impatient people who think fastload's loading screen isn't necessary.");
            comment.write("\n# Enabled = true, Disabled = false");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.LOCAL_RENDER_RADIUS_KEY) + " = how many chunks are loaded until 'building terrain' is completed on singleplayer join.");
            comment.write("\n# Min = 0, Max = 32 or your render distance, Whichever is smaller. Set 0 to disable.");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.SERVER_RENDER_RADIUS_KEY) + " = how many chunks are loaded until 'building terrain' is completed on server join.");
            comment.write("\n# Min = 0, Max = 32 or your render distance, Whichever is smaller. Set 0 to disable.");
            comment.write("\n#");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String writable(String key) {
        return "'" + key.toLowerCase() + "'";
    }

    private static int getInt(String key, int def, Bound bound) {
        try {
            int i = bound.minMax(Integer.parseInt(properties.getProperty(key)));
            properties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            FLConfig.logWarn(key);
            properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean parseBoolean(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (string.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (string.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException(string);
    }

    private static boolean getBoolean(String key, boolean def) {
        try {
            boolean b = FLConfig.parseBoolean(properties.getProperty(key));
            properties.setProperty(key, String.valueOf(b));
            return b;
        }
        catch (NumberFormatException e) {
            FLConfig.logWarn(key);
            properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    public static void storeProperty(String key, String value) {
        FLMath.ifDebugEnabled(() -> Fastload.LOGGER.info(key + ":" + value));
        properties.setProperty(key, value);
    }

    public static String retrieveProperty(String key) {
        return properties.get(key).toString();
    }

    static {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FLConfig.getRawChunkTryLimit();
        FLConfig.getRawDebug();
        FLConfig.getRawInstantLoad();
        FLConfig.getRawLocalRenderChunkRadius();
        FLConfig.getRawServerRenderChunkRadius();
        FLConfig.writeToDisk();
    }
}

