/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.forge;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.gui.impl.forge.ForgeHelpers;
import carbonconfiglib.networking.ICarbonPacket;
import carbonconfiglib.utils.Helpers;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;

public class SaveForgeConfigPacket
implements ICarbonPacket {
    ModConfig.Type type;
    String modId;
    byte[] data;

    public SaveForgeConfigPacket() {
    }

    public SaveForgeConfigPacket(ModConfig.Type type, String modId, byte[] data) {
        this.type = type;
        this.modId = modId;
        this.data = data;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.type);
        buffer.m_130072_(this.modId, Short.MAX_VALUE);
        buffer.m_130087_(this.data);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.type = (ModConfig.Type)buffer.m_130066_(ModConfig.Type.class);
        this.modId = buffer.m_130136_(Short.MAX_VALUE);
        this.data = buffer.m_130052_();
    }

    @Override
    public void process(Player player) {
        if (!CarbonConfig.hasPermission(player, 4)) {
            return;
        }
        ModConfig config = this.findConfig();
        if (config == null) {
            return;
        }
        ForgeHelpers.saveConfig((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(this.data)), config);
        CarbonConfig.LOGGER.info("Saved [" + this.modId + "] " + Helpers.firstLetterUppercase(this.type.extension()) + " Config");
    }

    private ModConfig findConfig() {
        for (ModConfig config : (Set)ConfigTracker.INSTANCE.configSets().get(this.type)) {
            if (!this.modId.equalsIgnoreCase(config.getModId())) continue;
            return config;
        }
        return null;
    }
}

