/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.core;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.common.blocks.DreamEssenceBlock;
import net.mehvahdjukaar.sleep_tight.common.blocks.ISleepTightBed;
import net.mehvahdjukaar.sleep_tight.common.network.ClientBoundSyncPlayerSleepCapMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class PlayerSleepData {
    protected static final String HOME_BED_NBT = "home_bed_id";
    protected static final String INSOMNIA_ELAPSE_NBT = "insomnia_elapses_at";
    protected static final String LAST_TIME_SLEPT_NBT = "last_time_slept";
    protected static final String CONSECUTIVE_NIGHTS_NBT = "consecutive_nights";
    protected static final String HOME_BED_LEVEL_NBT = "home_bed_nights";
    protected static final String USING_DOUBLE_BED_NBT = "using_double_bed";
    protected static final String LAST_KNOWN_TIME_NBT = "last_known_time";
    @Nullable
    private UUID homeBed = null;
    private long insomniaWillElapseTimeStamp = 0L;
    private long lastWokenUpTimeStamp = -1L;
    private long lastKnownTimeStamp = 0L;
    private int consecutiveNightsSlept = 0;
    private int nightsSleptInSameBed = 0;
    private boolean usingDoubleBed = false;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.homeBed != null) {
            tag.m_128362_(HOME_BED_NBT, this.homeBed);
        }
        tag.m_128356_(INSOMNIA_ELAPSE_NBT, this.insomniaWillElapseTimeStamp);
        tag.m_128356_(LAST_TIME_SLEPT_NBT, this.lastWokenUpTimeStamp);
        tag.m_128405_(CONSECUTIVE_NIGHTS_NBT, this.consecutiveNightsSlept);
        tag.m_128405_(HOME_BED_LEVEL_NBT, this.nightsSleptInSameBed);
        tag.m_128379_(USING_DOUBLE_BED_NBT, this.usingDoubleBed);
        tag.m_128356_(LAST_KNOWN_TIME_NBT, this.lastKnownTimeStamp);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_(HOME_BED_NBT)) {
            this.homeBed = tag.m_128342_(HOME_BED_NBT);
        }
        this.insomniaWillElapseTimeStamp = tag.m_128454_(INSOMNIA_ELAPSE_NBT);
        this.lastWokenUpTimeStamp = tag.m_128454_(LAST_TIME_SLEPT_NBT);
        this.consecutiveNightsSlept = tag.m_128451_(CONSECUTIVE_NIGHTS_NBT);
        this.nightsSleptInSameBed = tag.m_128451_(HOME_BED_LEVEL_NBT);
        this.usingDoubleBed = tag.m_128471_(USING_DOUBLE_BED_NBT);
        this.lastKnownTimeStamp = tag.m_128454_(LAST_KNOWN_TIME_NBT);
    }

    public void tick(ServerPlayer player) {
        long gameTime = player.m_9236_().m_46468_();
        if (gameTime < this.lastKnownTimeStamp) {
            if (this.isOnSleepCooldown((Player)player)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.time_skipped"), false);
            }
            this.insomniaWillElapseTimeStamp = 0L;
            this.lastWokenUpTimeStamp = -1L;
            this.lastKnownTimeStamp = gameTime;
            this.syncToClient(player);
        }
    }

    public void setInsomniaCooldown(long dayTimeNow, long cooldownDuration) {
        this.insomniaWillElapseTimeStamp = dayTimeNow + cooldownDuration;
        this.lastKnownTimeStamp = dayTimeNow;
    }

    public void setLasWokenUpTime(long dayTimeNow) {
        this.lastWokenUpTimeStamp = dayTimeNow;
        this.lastKnownTimeStamp = dayTimeNow;
    }

    public void increaseNightSleptInThisBed(BedData bed, Player player) {
        if (this.isBedLastSleptInto(bed)) {
            ++this.nightsSleptInSameBed;
            if (this.isBedFamiliar()) {
                bed.incrementBedLevel(player);
            }
        } else {
            if (this.nightsSleptInSameBed != 0) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sleep_tight.home_bed_lost"), false);
            }
            this.setLastSleptInto(bed);
            this.nightsSleptInSameBed = 0;
        }
    }

    public void increaseConsecutiveNightSleptCounter(long wakeUpTime) {
        long awakeTime = wakeUpTime - this.lastWokenUpTimeStamp;
        this.consecutiveNightsSlept = awakeTime > (long)CommonConfigs.SLEEP_INTERVAL.get().intValue() ? 0 : ++this.consecutiveNightsSlept;
    }

    public void resetConsecutiveNightSleptCounter() {
        this.consecutiveNightsSlept = 0;
    }

    public long getInsomniaCooldown(Player player) {
        if (player.m_150110_().f_35937_) {
            return 0L;
        }
        return this.insomniaWillElapseTimeStamp - player.m_9236_().m_46468_();
    }

    public float getInsomniaCooldownPercentage(Player player) {
        long timeLeft = this.getInsomniaCooldown(player);
        if (timeLeft < 0L) {
            return 0.0f;
        }
        long maxCooldown = this.insomniaWillElapseTimeStamp - this.lastWokenUpTimeStamp;
        return (float)timeLeft / (float)maxCooldown;
    }

    public boolean isOnSleepCooldown(Player player) {
        if (player.m_150110_().f_35937_) {
            return false;
        }
        return this.getInsomniaCooldown(player) > 0L;
    }

    public double getNightmareChance(Player player, BlockPos pos) {
        ISleepTightBed bed;
        if (player.m_150110_().f_35937_) {
            return 0.0;
        }
        int minNights = CommonConfigs.NIGHTMARES_CONSECUTIVE_NIGHTS.get();
        if (this.consecutiveNightsSlept < minNights) {
            return 0.0;
        }
        if (DreamEssenceBlock.isInRange(player.m_20183_(), player.m_9236_())) {
            return 0.0;
        }
        BlockState state = player.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof ISleepTightBed && !(bed = (ISleepTightBed)block).st_canCauseNightmares()) {
            return 0.0;
        }
        double chance = CommonConfigs.NIGHTMARE_CHANCE_INCREMENT_PER_NIGHT.get() * (double)(this.consecutiveNightsSlept - minNights - 1);
        if (!((PoiType)BuiltInRegistries.f_256941_.m_6246_(PoiTypes.f_218060_)).m_148692_(state)) {
            chance *= CommonConfigs.SPECIAL_BED_NIGHTMARE_CHANCE_MULT.get().doubleValue();
        }
        return chance;
    }

    @Nullable
    public UUID getLastBedSleptInto() {
        return this.homeBed;
    }

    public int getConsecutiveNightsSlept() {
        return this.consecutiveNightsSlept;
    }

    public float getBedFamiliarity() {
        return Math.min(1.0f, (float)this.nightsSleptInSameBed / (float)CommonConfigs.HOME_BED_REWARD_REQUIRED_NIGHTS.get().intValue());
    }

    public boolean isBedFamiliar() {
        return this.getBedFamiliarity() >= 1.0f;
    }

    public int getNightsSleptInHomeBed() {
        return this.nightsSleptInSameBed;
    }

    public long getLastWokenUpTime() {
        return this.lastWokenUpTimeStamp;
    }

    public long getInsomniaWillElapseTime() {
        return this.insomniaWillElapseTimeStamp;
    }

    public void acceptFromServer(UUID id, long insominaElapse, long sleepTimestamp, int nightSlept, int homeBedNights, boolean doubleBed) {
        this.homeBed = id;
        this.insomniaWillElapseTimeStamp = insominaElapse;
        this.consecutiveNightsSlept = nightSlept;
        this.lastWokenUpTimeStamp = sleepTimestamp;
        this.nightsSleptInSameBed = homeBedNights;
        this.usingDoubleBed = doubleBed;
    }

    public void syncToClient(ServerPlayer player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncPlayerSleepCapMessage(this));
    }

    public void setConsecutiveNightsSlept(int consecutiveNightsSlept) {
        this.consecutiveNightsSlept = consecutiveNightsSlept;
    }

    public void setNightsSleptInHomeBed(int nightsSleptInHomeBed) {
        this.nightsSleptInSameBed = nightsSleptInHomeBed;
    }

    public void copyFrom(PlayerSleepData oldData) {
        this.consecutiveNightsSlept = oldData.consecutiveNightsSlept;
        this.homeBed = oldData.homeBed;
        this.nightsSleptInSameBed = oldData.nightsSleptInSameBed;
        this.insomniaWillElapseTimeStamp = oldData.insomniaWillElapseTimeStamp;
        this.lastWokenUpTimeStamp = oldData.lastWokenUpTimeStamp;
        this.usingDoubleBed = oldData.usingDoubleBed;
    }

    public boolean usingDoubleBed() {
        return this.usingDoubleBed;
    }

    public void setDoubleBed(boolean doubleBed) {
        this.usingDoubleBed = doubleBed;
    }

    public boolean isBedLastSleptInto(@Nullable BedData bedData) {
        return bedData != null && bedData.getId().equals(this.getLastBedSleptInto());
    }

    public void setLastSleptInto(BedData data) {
        this.homeBed = data.getId();
    }
}

