/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.tiles;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.client.anim.PendulumAnimation;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.HammockPart;
import net.mehvahdjukaar.sleep_tight.common.blocks.HammockBlock;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.network.AccelerateHammockMessage;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.network.ServerBoundFallFromHammockMessage;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.joml.Vector3f;

public class HammockTile
extends BlockEntity {
    private final DyeColor color;
    private boolean accelerateLeft;
    private boolean accelerateRight;
    private float pivotOffset;
    private Direction direction;
    private final PendulumAnimation animation;

    public HammockTile(BlockPos blockPos, BlockState blockState) {
        super(SleepTight.HAMMOCK_TILE.get(), blockPos, blockState);
        this.color = ((HammockBlock)blockState.m_60734_()).getColor();
        this.pivotOffset = ((HammockPart)((Object)blockState.m_61143_(HammockBlock.PART))).getPivotOffset();
        this.direction = (Direction)blockState.m_61143_((Property)HammockBlock.f_54117_);
        this.animation = PlatHelper.getPhysicalSide().isClient() ? new PendulumAnimation(ClientConfigs.HAMMOCK_ANIMATION_PARAM, this::getRotationAxis) : null;
    }

    private Vector3f getRotationAxis() {
        return ((Direction)this.m_58900_().m_61143_((Property)HammockBlock.f_54117_)).m_253071_();
    }

    public DyeColor getColor() {
        return this.color;
    }

    public float getRoll(float partialTicks) {
        if (!ClientConfigs.HAMMOCK_ANIMATION.get().booleanValue()) {
            return 0.0f;
        }
        return this.animation.getAngle(partialTicks);
    }

    public float getPivotOffset() {
        return this.pivotOffset;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-3, 0, -3), this.f_58858_.m_7918_(3, 2, 3));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HammockTile e) {
        if (e.accelerateLeft || e.accelerateRight) {
            double push = ClientConfigs.SWING_FORCE.get();
            e.animation.addImpulse((float)(push * (double)(e.accelerateLeft ? -1 : 1)));
            NetworkHandler.CHANNEL.sendToServer((Message)new AccelerateHammockMessage(pos, e.accelerateLeft));
        }
        e.animation.tick(false);
        if (Mth.m_14154_((float)e.animation.getAngle(0.0f)) > 86.0f && ClientConfigs.HAMMOCK_FALL.get().booleanValue()) {
            for (BedEntity b : e.f_58857_.m_45976_(BedEntity.class, new AABB(pos))) {
                for (Entity p : b.m_20197_()) {
                    Player pp;
                    if (p instanceof Player && (pp = (Player)p).m_7578_()) {
                        NetworkHandler.CHANNEL.sendToServer((Message)new ServerBoundFallFromHammockMessage());
                        continue;
                    }
                    return;
                }
            }
        }
        e.pivotOffset = ((HammockPart)((Object)state.m_61143_(HammockBlock.PART))).getPivotOffset();
        e.direction = (Direction)state.m_61143_((Property)HammockBlock.f_54117_);
        e.accelerateLeft = false;
        e.accelerateRight = false;
    }

    public void accelerateLeft() {
        this.accelerateLeft = true;
    }

    public void accelerateRight() {
        this.accelerateRight = true;
    }

    public void addImpulse(float vel) {
        this.animation.addImpulse(vel);
    }
}

