/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.items;

import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.common.entities.BedbugEntity;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BedbugEggsItem
extends Item {
    public BedbugEggsItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOnBed(Player player, InteractionHand hand, ItemStack stack, BlockState state, BlockPos pos, BlockHitResult hit) {
        Level level = player.m_9236_();
        if (BedbugEggsItem.infestBed(level, pos, null)) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            level.m_5594_(player, pos, SoundEvents.f_12534_, SoundSource.PLAYERS, 0.6f, 1.7f);
            level.m_5594_(player, pos, SoundEvents.f_12422_, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (level.f_46443_) {
                Vec3 h = hit.m_82450_();
                for (int i = 0; i < 8; ++i) {
                    level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7968_()), h.f_82479_, h.f_82480_ + 0.1, h.f_82481_, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08, ((double)level.f_46441_.m_188501_() - 0.5) * 0.08);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean infestBed(Level level, BlockPos pos, @Nullable BedbugEntity entity) {
        BedData data = STPlatStuff.getBedData(level, pos);
        if (data != null && !data.isInfested()) {
            CompoundTag mobTag;
            if (entity != null) {
                mobTag = BedbugEggsItem.prepareMobTagForContainer((Entity)entity, 0.5);
            } else {
                mobTag = new CompoundTag();
                mobTag.m_128359_("id", SleepTight.BEDBUG_ENTITY.getId().toString());
            }
            data.setBedBug(mobTag);
            BlockEntity tile = level.m_7702_(pos);
            if (tile != null) {
                level.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
                tile.m_6596_();
            }
            return true;
        }
        return false;
    }

    private static CompoundTag prepareMobTagForContainer(Entity entity, double yOffset) {
        double px = 0.5;
        double py = yOffset + 1.0E-4;
        double pz = 0.5;
        entity.m_6034_(px, py, pz);
        entity.f_19790_ = px;
        entity.f_19791_ = py;
        entity.f_19792_ = pz;
        if (entity.m_20159_()) {
            entity.m_20202_().m_20153_();
        }
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.f_20886_ = 0.0f;
            le.f_20885_ = 0.0f;
            le.f_267362_.m_267771_(0.0f);
            le.f_20917_ = 0;
            le.f_20916_ = 0;
            le.f_20921_ = 0.0f;
        }
        entity.m_146922_(0.0f);
        entity.f_19859_ = 0.0f;
        entity.f_19860_ = 0.0f;
        entity.m_146926_(0.0f);
        entity.m_20095_();
        entity.f_19802_ = 0;
        CompoundTag mobTag = new CompoundTag();
        entity.m_20223_(mobTag);
        if (mobTag.m_128456_()) {
            return null;
        }
        mobTag.m_128473_("Passengers");
        mobTag.m_128473_("Leash");
        mobTag.m_128473_("UUID");
        return mobTag;
    }
}

