/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.sleep_tight.STPlatStuff;
import net.mehvahdjukaar.sleep_tight.core.BedData;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ModCommands {
    public static void init() {
        RegHelper.addCommandRegistration(ModCommands::register);
    }

    private static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep_tight").requires(p -> p.m_6761_(2))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep_cooldown").then(GetInsomnia.register(dispatcher))).then(SetInsomnia.register(dispatcher)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"consecutive_nights").then(SetNights.register(dispatcher))).then(GetNights.register(dispatcher)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"home_bed_nights").then(GetHomeBedNights.register(dispatcher))).then(SetHomeBedNights.register(dispatcher)))).then(Commands.m_82127_((String)"home_bed_position").then(SetHomeBedPosition.register(dispatcher, commandBuildContext)))).then(Commands.m_82127_((String)"nightmare_chance").then(GetNightmareChance.register(dispatcher))));
    }

    private static class GetInsomnia
    implements Command<CommandSourceStack> {
        private GetInsomnia() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"get").executes((Command)new GetInsomnia());
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int timeLeft = (int)cap.getInsomniaCooldown((Player)serverPlayer);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"message.sleep_tight.command.get_insomnia", (Object[])new Object[]{timeLeft}), false);
                return timeLeft;
            }
            return 0;
        }
    }

    private static class SetInsomnia
    implements Command<CommandSourceStack> {
        private SetInsomnia() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"cooldown", (ArgumentType)IntegerArgumentType.integer((int)0)).executes((Command)new SetInsomnia()));
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int cooldown = IntegerArgumentType.getInteger(context, (String)"cooldown");
                cap.setInsomniaCooldown(serverPlayer.m_9236_().m_8044_(), cooldown);
                cap.syncToClient(serverPlayer);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sleep_tight.command.set_insomnia"), false);
                return cooldown;
            }
            return 0;
        }
    }

    private static class SetNights
    implements Command<CommandSourceStack> {
        private SetNights() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"consecutive_nights", (ArgumentType)IntegerArgumentType.integer((int)0)).executes((Command)new SetNights()));
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int nights = IntegerArgumentType.getInteger(context, (String)"consecutive_nights");
                cap.setConsecutiveNightsSlept(nights);
                cap.syncToClient(serverPlayer);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sleep_tight.command.set_nights"), false);
                return nights;
            }
            return 0;
        }
    }

    private static class GetNights
    implements Command<CommandSourceStack> {
        private GetNights() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"get").executes((Command)new GetNights());
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int timeLeft = cap.getConsecutiveNightsSlept();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"message.sleep_tight.command.get_nights", (Object[])new Object[]{timeLeft}), false);
                return timeLeft;
            }
            return 0;
        }
    }

    private static class GetHomeBedNights
    implements Command<CommandSourceStack> {
        private GetHomeBedNights() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"get").executes((Command)new GetHomeBedNights());
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int timeLeft = cap.getNightsSleptInHomeBed();
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"message.sleep_tight.command.get_home_bed_nights", (Object[])new Object[]{timeLeft}), false);
                return timeLeft;
            }
            return 0;
        }
    }

    private static class SetHomeBedNights
    implements Command<CommandSourceStack> {
        private SetHomeBedNights() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"nights", (ArgumentType)IntegerArgumentType.integer((int)0)).executes((Command)new SetHomeBedNights()));
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                int nights = IntegerArgumentType.getInteger(context, (String)"nights");
                cap.setNightsSleptInHomeBed(nights);
                cap.syncToClient(serverPlayer);
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sleep_tight.command.set_home_bed_nights"), false);
                return nights;
            }
            return 0;
        }
    }

    private static class SetHomeBedPosition
    implements Command<CommandSourceStack> {
        private SetHomeBedPosition() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
            return Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes((Command)new SetHomeBedPosition()));
        }

        public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
                BedData data = STPlatStuff.getBedData(serverPlayer.m_9236_(), pos);
                if (data != null) {
                    PlayerSleepData playerData = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                    playerData.setLastSleptInto(data);
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"message.sleep_tight.command.set_home_bed_position"), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.sleep_tight.command.set_home_bed_position_fail"));
                return 0;
            }
            return 0;
        }
    }

    private static class GetNightmareChance
    implements Command<CommandSourceStack> {
        private GetNightmareChance() {
        }

        public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
            return Commands.m_82127_((String)"get").executes((Command)new GetNightmareChance());
        }

        public int run(CommandContext<CommandSourceStack> context) {
            Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                PlayerSleepData cap = STPlatStuff.getPlayerSleepData((Player)serverPlayer);
                double nightmareChance = cap.getNightmareChance((Player)serverPlayer, serverPlayer.m_20097_());
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"message.sleep_tight.command.nightmare_chance", (Object[])new Object[]{String.format("%.3f", nightmareChance)}), false);
            }
            return 0;
        }
    }
}

