/*
 * Decompiled with CFR 0.152.
 */
package com.limitedchunks.event;

import com.limitedchunks.LimitedChunks;
import com.limitedchunks.config.CommonConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    static Map<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>> posToPlayerID = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>>();
    static Map<ResourceKey<Level>, HashMap<UUID, LongSet>> playerIDToPos = new HashMap<ResourceKey<Level>, HashMap<UUID, LongSet>>();
    static Map<ResourceKey<Level>, Queue<ChunkPosAndTime>> unloadQue = new HashMap<ResourceKey<Level>, Queue<ChunkPosAndTime>>();
    public static Set<String> excludedTickets = new HashSet<String>();

    private static Long2ObjectOpenHashMap<UUID> getPosToPlayerIDMap(ResourceKey<Level> worldID) {
        return posToPlayerID.computeIfAbsent(worldID, k -> new Long2ObjectOpenHashMap());
    }

    private static HashMap<UUID, LongSet> getPlayerIDToPosMap(ResourceKey<Level> worldID) {
        return playerIDToPos.computeIfAbsent(worldID, k -> new HashMap());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_() || event.phase == TickEvent.Phase.START) {
            return;
        }
        ServerLevel world = (ServerLevel)event.level;
        Queue<ChunkPosAndTime> queue = unloadQue.get(world.m_46472_());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        ChunkPosAndTime current = queue.peek();
        if (current != null && current.time < world.m_7654_().m_129932_()) {
            queue.poll();
            EventHandler.checkLoadedAndClear(current.pos, world);
        }
    }

    private static void checkLoadedAndClear(long pos, ServerLevel world) {
        ServerPlayer player;
        Long2ObjectOpenHashMap<UUID> worldPositionsLoaded = EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.m_46472_());
        if (!worldPositionsLoaded.containsKey(pos)) {
            return;
        }
        UUID ownerUUID = (UUID)worldPositionsLoaded.get(pos);
        if (ownerUUID != null && (player = world.m_7654_().m_6846_().m_11259_(ownerUUID)) != null) {
            return;
        }
        SortedArraySet ticketsE = (SortedArraySet)world.m_7726_().f_8327_.f_140761_.get(pos);
        if (ticketsE == null) {
            return;
        }
        ArrayList<Ticket> ticketsToRemove = new ArrayList<Ticket>();
        for (Ticket ticket : ticketsE) {
            if (ticket == null) continue;
            if (!excludedTickets.contains(ticket.m_9428_().toString())) {
                if (((CommonConfiguration)LimitedChunks.config.getCommonConfig()).debugLog) {
                    LimitedChunks.LOGGER.info("Unloading ticket:" + ticket.m_9428_().toString() + " at chunkpos:" + new ChunkPos(pos));
                }
                ticketsToRemove.add(ticket);
                continue;
            }
            if (ticket.m_9428_() != TicketType.f_9444_) continue;
            ChunkPos chunkPos = new ChunkPos(pos);
            Player closeset = world.m_5788_((double)(chunkPos.f_45578_ << 4), 0.0, (double)(chunkPos.f_45579_ << 4), -1.0, null);
            if (closeset == null) continue;
            worldPositionsLoaded.put(pos, (Object)closeset.m_20148_());
            return;
        }
        for (Ticket ticket : ticketsToRemove) {
            world.m_7726_().f_8327_.m_140818_(pos, ticket);
        }
    }

    public static void initDefaultExcludes() {
        excludedTickets = new HashSet<String>();
        excludedTickets.add(TicketType.f_9448_.toString());
        excludedTickets.add(TicketType.f_9444_.toString());
        excludedTickets.add(TicketType.f_9442_.toString());
        excludedTickets.add(TicketType.f_9449_.toString());
        excludedTickets.add(TicketType.f_9447_.toString());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        Player closeset = world.m_5788_((double)(event.getChunk().m_7697_().f_45578_ << 4), 0.0, (double)(event.getChunk().m_7697_().f_45579_ << 4), -1.0, null);
        long pos = event.getChunk().m_7697_().m_45588_();
        if (closeset != null) {
            EventHandler.getPlayerIDToPosMap((ResourceKey<Level>)world.m_46472_()).computeIfAbsent(closeset.m_20148_(), k -> new LongOpenHashSet()).add(pos);
            EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.m_46472_()).put(pos, (Object)closeset.m_20148_());
        } else {
            EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.m_46472_()).put(pos, null);
            Queue quedChunks = unloadQue.computeIfAbsent((ResourceKey<Level>)world.m_46472_(), s -> new PriorityQueue());
            quedChunks.add(new ChunkPosAndTime(pos, world.m_7654_().m_129932_() + (long)(((CommonConfiguration)LimitedChunks.config.getCommonConfig()).chunkunloadnoplayer * 1000 * 60)));
        }
    }

    @SubscribeEvent
    public static void onChunkUnLoad(ChunkEvent.Unload event) {
        Set positions;
        if (event.getLevel().m_5776_()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        long pos = event.getChunk().m_7697_().m_45588_();
        UUID playerID = (UUID)EventHandler.getPosToPlayerIDMap((ResourceKey<Level>)world.m_46472_()).remove(pos);
        if (playerID != null && (positions = (Set)EventHandler.getPlayerIDToPosMap((ResourceKey<Level>)world.m_46472_()).get(playerID)) != null) {
            positions.remove(pos);
        }
    }

    @SubscribeEvent
    public static void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getEntity().m_9236_();
        for (Map.Entry<ResourceKey<Level>, HashMap<UUID, LongSet>> dimEntry : playerIDToPos.entrySet()) {
            LongSet chunksFromPlayer;
            HashMap<UUID, LongSet> playerToPosMap = dimEntry.getValue();
            if (playerToPosMap == null || (chunksFromPlayer = playerToPosMap.remove(event.getEntity().m_20148_())) == null) continue;
            Queue quedChunks = unloadQue.computeIfAbsent(dimEntry.getKey(), s -> new PriorityQueue());
            LongIterator longIterator = chunksFromPlayer.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                quedChunks.add(new ChunkPosAndTime(pos, world.m_7654_().m_129932_() + (long)(((CommonConfiguration)LimitedChunks.config.getCommonConfig()).chunkunloadnoplayer * 1000 * 60)));
            }
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        posToPlayerID = new HashMap<ResourceKey<Level>, Long2ObjectOpenHashMap<UUID>>();
        playerIDToPos = new HashMap<ResourceKey<Level>, HashMap<UUID, LongSet>>();
        unloadQue = new HashMap<ResourceKey<Level>, Queue<ChunkPosAndTime>>();
    }

    private static class ChunkPosAndTime
    implements Comparable<ChunkPosAndTime> {
        final long pos;
        final long time;

        ChunkPosAndTime(long pos, long time) {
            this.pos = pos;
            this.time = time;
        }

        @Override
        public int compareTo(ChunkPosAndTime o) {
            return (int)(this.time - o.time);
        }
    }
}

