/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.network.packets;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.common.listeners.TemperatureItemListener;
import sfiomn.legendarysurvivaloverhaul.network.NetworkHandler;

public class SyncTemperatureItemsPacket {
    private final Map<ResourceLocation, JsonTemperatureResistance> temperatureItems;
    private final int size;

    public SyncTemperatureItemsPacket(Map<ResourceLocation, JsonTemperatureResistance> temperatureItems) {
        this.temperatureItems = Map.copyOf(temperatureItems);
        this.size = temperatureItems.size();
    }

    public static void encode(SyncTemperatureItemsPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.size);
        for (Map.Entry<ResourceLocation, JsonTemperatureResistance> e : message.temperatureItems.entrySet()) {
            buffer.m_130085_(e.getKey());
            DataResult r = JsonTemperatureResistance.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)e.getValue());
            r.result().ifPresent(j -> buffer.m_130079_((CompoundTag)j));
        }
    }

    public static SyncTemperatureItemsPacket decode(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        HashMap<ResourceLocation, JsonTemperatureResistance> temperatureItems = new HashMap<ResourceLocation, JsonTemperatureResistance>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation key = buffer.m_130281_();
            CompoundTag tag = buffer.m_130260_();
            if (tag == null) continue;
            DataResult r = JsonTemperatureResistance.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag);
            r.result().ifPresent(t -> temperatureItems.put(key, (JsonTemperatureResistance)t));
        }
        return new SyncTemperatureItemsPacket(temperatureItems);
    }

    public static void handle(SyncTemperatureItemsPacket message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> SyncTemperatureItemsPacket.syncTemperatureItems(message.temperatureItems)));
        supplier.get().setPacketHandled(true);
    }

    public static DistExecutor.SafeRunnable syncTemperatureItems(final Map<ResourceLocation, JsonTemperatureResistance> temperatureItems) {
        return new DistExecutor.SafeRunnable(){
            private static final long serialVersionUID = 1L;

            public void run() {
                TemperatureItemListener.acceptServerTemperatureItems(temperatureItems);
            }
        };
    }

    public static void sendTo(PacketDistributor.PacketTarget packetDistributor, Map<ResourceLocation, JsonTemperatureResistance> temperatureItems) {
        NetworkHandler.INSTANCE.send(packetDistributor, (Object)new SyncTemperatureItemsPacket(temperatureItems));
    }
}

