/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.listeners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.LegendarySurvivalOverhaul;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonTemperatureResistance;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ITemperatureItemManager;
import sfiomn.legendarysurvivaloverhaul.network.packets.SyncTemperatureItemsPacket;

public class TemperatureItemListener
extends SimpleJsonResourceReloadListener
implements ITemperatureItemManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<ResourceLocation, JsonTemperatureResistance> TEMPERATURE_ITEMS = new HashMap<ResourceLocation, JsonTemperatureResistance>();

    public TemperatureItemListener() {
        super(GSON, "legendarysurvivaloverhaul/temperature/items");
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> resourceLocationJsonElementMap, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        TEMPERATURE_ITEMS.clear();
        resourceLocationJsonElementMap.forEach((key, json) -> {
            try {
                DataResult parsedJson = JsonTemperatureResistance.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                JsonTemperatureResistance temperatures = (JsonTemperatureResistance)parsedJson.getOrThrow(false, error -> LegendarySurvivalOverhaul.LOGGER.error("Failed parsing temperature item : {}", error));
                if (ModList.get().isLoaded(key.m_135827_())) {
                    TEMPERATURE_ITEMS.put((ResourceLocation)key, temperatures);
                }
            }
            catch (JsonParseException error2) {
                LegendarySurvivalOverhaul.LOGGER.error("Failed to parse temperature item json {}", key);
            }
        });
        LegendarySurvivalOverhaul.LOGGER.info("Loaded {} temperature items", (Object)TEMPERATURE_ITEMS.size());
    }

    public static void sendDataToClient(PacketDistributor.PacketTarget packetTarget) {
        SyncTemperatureItemsPacket.sendTo(packetTarget, TEMPERATURE_ITEMS);
    }

    public static void acceptServerTemperatureItems(Map<ResourceLocation, JsonTemperatureResistance> temperatureItems) {
        TEMPERATURE_ITEMS.clear();
        TEMPERATURE_ITEMS.putAll(temperatureItems);
    }

    @Override
    public JsonTemperatureResistance get(ResourceLocation itemRegistryName) {
        return TEMPERATURE_ITEMS.get(itemRegistryName);
    }
}

