/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarysurvivaloverhaul.common.items.drink;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonMobEffect;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstBlock;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.HydrationEnum;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.api.wetness.WetnessUtil;
import sfiomn.legendarysurvivaloverhaul.common.items.drink.DrinkItem;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.registry.SoundRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class CanteenItem
extends DrinkItem {
    public CanteenItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public int getMaxCapacity() {
        return Config.Baked.canteenCapacity;
    }

    @Override
    public int m_8105_(@NotNull ItemStack stack) {
        return CanteenItem.canDrink(stack) ? 40 : 0;
    }

    public static boolean canDrink(ItemStack stack) {
        return ThirstUtil.getCapacityTag(stack) > 0 && ThirstUtil.getHydrationEnumTag(stack) != null;
    }

    public boolean canFill(ItemStack stack) {
        return Config.Baked.allowOverridePurifiedWater ? ThirstUtil.getCapacityTag(stack) < this.getMaxCapacity() : ThirstUtil.getCapacityTag(stack) < this.getMaxCapacity() && ThirstUtil.getHydrationEnumTag(stack) != HydrationEnum.PURIFIED;
    }

    public void fill(ItemStack stack) {
        ThirstUtil.setCapacityTag(stack, Math.min(this.getMaxCapacity(), ThirstUtil.getCapacityTag(stack) + 1));
        ThirstUtil.setHydrationEnumTag(stack, HydrationEnum.NORMAL);
    }

    public boolean isWater(Level level, BlockPos blockPos) {
        FluidState fluidState = level.m_6425_(blockPos);
        JsonThirstBlock thirstInfo = ThirstDataManager.getBlock(fluidState);
        if (thirstInfo == null) {
            thirstInfo = ThirstDataManager.getBlock(level.m_8055_(blockPos));
        }
        if (thirstInfo != null && thirstInfo.hydration == 3 && thirstInfo.saturation == 0.0f && !thirstInfo.effects.isEmpty()) {
            for (JsonMobEffect jsonMobEffect : thirstInfo.effects) {
                if (!jsonMobEffect.name.equalsIgnoreCase(MobEffectRegistry.THIRST.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext useOnContext) {
        boolean isWater = this.isWater(useOnContext.m_43725_(), useOnContext.m_8083_());
        ItemStack canteen = useOnContext.m_43722_();
        Player player = useOnContext.m_43723_();
        if (this.canFill(canteen) && isWater && player != null) {
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ForgeRegistries.SOUND_EVENTS.getHolder((Object)SoundEvents.f_11770_).ifPresent(soundHolder -> serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(soundHolder, SoundSource.PLAYERS, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), 1.0f, 1.0f, player.m_9236_().m_213780_().m_188505_())));
            }
            this.fill(canteen);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack canteen;
        HitResult positionLookedAt = player.m_19907_(player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()) / 2.0, 0.0f, true);
        boolean isWater = false;
        if (positionLookedAt.m_6662_() == HitResult.Type.BLOCK) {
            isWater = this.isWater(level, ((BlockHitResult)positionLookedAt).m_82425_());
        }
        if (this.canFill(canteen = player.m_21120_(hand)) && isWater) {
            player.m_6674_(InteractionHand.MAIN_HAND);
            player.m_5496_(SoundEvents.f_11770_, 1.0f, 1.0f);
            this.fill(canteen);
            return InteractionResultHolder.m_19096_((Object)canteen);
        }
        if (player.m_6047_() && player.m_5686_(1.0f) < -60.0f && CanteenItem.canDrink(canteen) && Config.Baked.selfWateringCanteenEnabled) {
            player.m_5496_((SoundEvent)SoundRegistry.SELF_WATERING.get(), 1.0f, 1.0f);
            if (player.m_6060_()) {
                player.m_20254_(0);
            }
            if (Config.Baked.selfWateringCanteenWetnessIncrease > 0) {
                WetnessUtil.addWetness(player, Config.Baked.selfWateringCanteenWetnessIncrease);
            }
            player.m_6674_(InteractionHand.MAIN_HAND);
            CanteenItem.shrinkCapacity(canteen);
            return InteractionResultHolder.m_19096_((Object)canteen);
        }
        if (CanteenItem.canDrink(canteen) && !CapabilityUtil.getThirstCapability(player).isHydrationLevelAtMax()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)canteen);
        }
        return InteractionResultHolder.m_19100_((Object)canteen);
    }

    @Override
    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, Level level, @NotNull LivingEntity entity) {
        if (level.f_46443_ || !(entity instanceof Player)) {
            return stack;
        }
        Player player = (Player)entity;
        this.runSecondaryEffect(player, stack);
        CanteenItem.shrinkCapacity(stack);
        return stack;
    }

    public static void shrinkCapacity(ItemStack stack) {
        int newCapacity = ThirstUtil.getCapacityTag(stack) - 1;
        ThirstUtil.setCapacityTag(stack, newCapacity);
        if (newCapacity == 0) {
            ThirstUtil.removeHydrationEnumTag(stack);
        }
    }

    @NotNull
    public String m_5671_(ItemStack stack) {
        if (ThirstUtil.getCapacityTag(stack) == 0) {
            return "item.legendarysurvivaloverhaul.canteen_empty";
        }
        if (ThirstUtil.getHydrationEnumTag(stack) == HydrationEnum.PURIFIED) {
            return "item.legendarysurvivaloverhaul.canteen_purified";
        }
        return "item.legendarysurvivaloverhaul.canteen";
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return ThirstUtil.getCapacityTag(stack) > 0;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        float max = this.getMaxCapacity();
        if (max == 0.0f) {
            return 0;
        }
        return Math.round((float)ThirstUtil.getCapacityTag(stack) / max * 13.0f);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        float f = Math.max(0.0f, (float)ThirstUtil.getCapacityTag(stack) / (float)this.getMaxCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }
}

